<?php
require_once('utility.php');
function stop_liteserver($argv) {
	global $DTASCFG_XML_FILE, $BACKEND;
	
	$cfg_xml		= simplexml_load_file($DTASCFG_XML_FILE);
    $cluster_xml	= (count($argv) > 0 && $argv[0] != "" ? $cfg_xml->$argv[0] : $cfg_xml);

	$esxi_ip							= chop($cluster_xml->esxi->ip);
	$esxi_username						= chop($cluster_xml->esxi->username);
	$esxi_password						= $cluster_xml->esxi->password;
	$sandbox_controller_admin_username	= chop($cfg_xml->sandbox_controller->admin_username);
	$sandbox_controller_admin_password	= $cfg_xml->sandbox_controller->admin_password;	
    $sandbox_controller_prefix			= chop($cluster_xml->sandbox_controller->prefix);

    $controller_vix_vmpath = get_vm_vixpath($esxi_ip, $esxi_username, $esxi_password, $sandbox_controller_prefix);
        
    // Escape variables since then they will be used in command line
    $esxi_username = escapeshellarg($esxi_username);
    $esxi_password = escapeshellarg($esxi_password);
    $sandbox_controller_admin_username = escapeshellarg($sandbox_controller_admin_username);
    $sandbox_controller_admin_password = escapeshellarg($sandbox_controller_admin_password);
    
	unset($result_array);
	exec("$BACKEND run_program_in_vm_by_vix $esxi_ip $esxi_username $esxi_password $sandbox_controller_admin_username $sandbox_controller_admin_password \"$controller_vix_vmpath\" /sbin/service liteserverd stop 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);	
}
